﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Dokumenty wg dni</title>

    <script runat="server"> 

        static DokumentyParams dparametry;

        [Context(Required = false)]
        public static DokumentyParams DParametry {
            get { return dparametry; }
            set { dparametry = value; }
        }

        public class ParametryContext : ContextBase
        {
            public ParametryContext(Context cx)
                : base(cx)
            {
            }

            bool _ignorujZaliczkowe = true;

            [Priority(10)]
            public bool IgnorujZaliczkowe
            {
                get { return _ignorujZaliczkowe; }
                set { _ignorujZaliczkowe = value; OnChanged(EventArgs.Empty); }
            }
        }

        ParametryContext parametry;

        [Context]
        public ParametryContext Parametry
        {
            get { return parametry; }
            set { parametry = value; }
        }

        public class Total : IComparable
        {
            readonly Date data;
            decimal netto = 0;
            decimal vat = 0;
            decimal brutto = 0;
            int liczba = 0;

            public Total(Date data)
            {
                this.data = data;
            }
            public void Add(DokumentHandlowy dok)
            {
                netto += dok.Suma.Netto;
                vat += dok.Suma.VAT;
                brutto += dok.Suma.Brutto;
                ++liczba;
            }
            public Date Data
            {
                get { return data; }
            }
            public int Liczba
            {
                get { return liczba; }
            }
            public decimal Netto
            {
                get { return netto; }
            }
            public decimal Brutto
            {
                get { return brutto; }
            }
            public decimal VAT
            {
                get { return vat; }
            }
            public int CompareTo(object obj)
            {
                Total t = (Total)obj;
                return data.CompareTo(t.data);
            }
        }

        void OnContextLoad(Object sender, EventArgs args)
        {

            if (DParametry != null) {
                string partia = CaptionAttribute.EnumToString(DParametry.FiltrTypuPartii);
                string typ = CaptionAttribute.EnumToString(DParametry.FiltrTypu);
                string linia = "|Partia: <STRONG>" + partia + "</STRONG>, Typ: <STRONG>" + typ + "</STRONG>";
                ReportHeader.Title += linia;
            }
            
            Row[] rows = (Row[])dc[typeof(Row[])];
            Hashtable result = new Hashtable();
            int licznik = 0;
            foreach (DokumentHandlowy dokument in rows)
            {
                if (++licznik % 30 == 0)
                    System.Diagnostics.Trace.Write(licznik * 100 / rows.Length, "Progress");
                if (dokument.Anulowany) continue;
                if (dokument.Definicja.DuplikatWartosci) continue;
                if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;
                Total t = (Total)result[dokument.Data];
                if (t == null)
                {
                    t = new Total(dokument.Data);
                    result.Add(dokument.Data, t);
                }
                t.Add(dokument);
            }

            ArrayList lista = new ArrayList(result.Values);
            lista.Sort();
            Grid.DataSource = lista;
        }

    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server" action="#">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Dokumenty wg dni|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}</STRONG>"
            runat="server" DataMember3="Magazyn" DataMember2="FromTo"></eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
            GroupData0="Data" GroupLine="Tydzień: {0:w}" ShowGroupSum="True">
            <Columns>
                <ea:GridColumn Caption="Lp." DataMember="#" Align="Right" Width="4" EncodeHTML="True"
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Data" Width="15" EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Caption="Dzień tygodnia" DataMember="Data" Format="{0:dddd}" Total="Info"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Netto" Align="Right" Width="15" Format="{0:n}" Total="Sum"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn DataMember="VAT" Align="Right" Width="15" Format="{0:n}" Total="Sum"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Brutto" Align="Right" Width="15" Format="{0:n}" Total="Sum"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Liczba" Align="Right" Width="8" Total="Sum" EncodeHTML="True"
                    runat="server">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
        </eb:ReportFooter>
    </form>
</body>
</html>

